<?php
 
		// Make sure SimplePie is included. You may need to change this to match the location of simplepie.inc.
		require_once('simplepie.inc');
		 
		// We'll process this feed with all of the default options.
		$feed = new SimplePie();
		 
		// Set which feed to process.
		$feed->set_feed_url(array('http://blog.afterfuture.net/promociones/rss.xml', 'http://blog.afterfuture.net/articulos/rss.xml'));
		$feed->set_cache_location($_SERVER['DOCUMENT_ROOT'].'/templates_c/');
		
		$feed->set_item_limit(3);
		
		
		// Run SimplePie.
		$feed->init();
		 
		// This makes sure that the content is sent to the browser as text/html and the UTF-8 character set (since we didn't change it).
		$feed->handle_content_type();
		 
		// Let's begin our XHTML webpage code.  The DOCTYPE is supposed to be the very first thing, so we'll keep it on the same line as the closing-PHP tag.
?>
<style>
li.publicacion{
	border:1px solid #9ca8ad;
	float:left;
	width:280px !important;
	height:100px;
	list-style:none;
	margin:5px 18px;
	display:block;
	}
	
div.news_pic{
	position:relative;
	width:280px;
	height:100px;
	border:0px solid #fff;}
	
div.news_pic img{
	overflow:hidden;
	width:280px;
	height:100px;
	}
div.news_tit{
	color:#900;
	margin:4px 4px 0 4px;
	float:left;	
	width:300px;
	height:16px;
	border:0px solid #fff;}
	
div.news_tit a{
	font-weight:normal;
	font-family: 'Titillium Web', sans-serif !important;
	font-size:14px !important;
	text-decoration:none;
	color:#06ccff;
	text-shadow:none !important;
	}
div.news_desc{
	margin:4px 4px 0 4px;
	float:left;	
	width:auto;
	overflow:hidden;
	height:60px;
	border:0px solid #fff;}
	
div.news_desc a{
	font-weight:normal;
	font-family: 'Titillium Web', sans-serif !important;
	font-size:14px !important;
	text-decoration:none;
	color:#ccc;
	text-shadow:none !important;
		
	}
div.cont_publicacion{
	opacity:0.7;
	filter:alpha(opacity=70); /* For IE8 and earlier */
	background:#171a20;
	width:auto;
	height:100px;
	overflow:hidden;
	position:relative;
	margin:-28px 0 0 0;
	overflow:hidden;
	}
	
div.wrap_publicacion{
	overflow:hidden;
	width:280px !important;
	height:100px;
}
</style>
    
        <ul>
                <?php $i=1; foreach ($feed->get_items() as $item):?>
                
                    	<li class="publicacion">
                            <div class="wrap_publicacion">  
                                <div class="news_pic"><a href="<?=$item->get_permalink()?>" class="overlayed fancybox.iframe"><?=obtener_thumb($item->get_description(), 280, 100, 85)?></a></div>
                                <div class="cont_publicacion">
                                    <div class="news_tit"><a href="<?=$item->get_permalink()?>" class="overlayed fancybox.iframe"><?=cortar_texto($item->get_title(), 36)?></a></div>
                                    <div class="news_desc"><a href="<?=$item->get_permalink()?>" class="overlayed fancybox.iframe"><?=cortar_texto($item->get_description(), 150)?></a></div>
                                </div>
                            </div>
                        </li>
                
                <?php $i++; endforeach;?>
        </ul>
{literal}
	<script>
	
	$('li.publicacion').hover(
			function(){
					$('.cont_publicacion', this).animate({
								marginTop: "-100px",
								opacity: 0.9,
							}, 200)
				},
			
			function(){
					$('.cont_publicacion', this).animate({
								marginTop: "-28px",
								opacity: 0.7,
							}, 200)
				}
		);	
	
		
   
    </script>
{/literal}